<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:dok="http://crd.gov.pl/wzor/2016/11/10/3648/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:typy="http://crd.gov.pl/xml/schematy/typy/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" version="1.0">
	<xsl:output encoding="UTF-8" indent="yes" media-type="text/html" method="xml" version="1.0"/>
	<xsl:template match="/dok:Dokument">
		<html xml:lang="pl">
			<head>
				<meta content="text/html; charset=UTF-8" http-equiv="content-type"/>
				<title>
					Deklaracja o wysokości opłaty za gospodarowanie odpadami komunalnymi składana przez właścicieli nieruchomości, na których znajdują się domki letniskowe lub innych nieruchomości wykorzystywanych na cele rekreacyjno-wypoczynkowe, wykorzystywanych jedynie przez część roku
					<xsl:text> (</xsl:text>
					F.PO.DEK.ODP.KOM.D.L.P035
					<xsl:text>)</xsl:text>
				</title>
				<style type="text/css">
					<xsl:text>.fform { font-family: sans-serif; font-size: 10pt; color: black; } </xsl:text>
					<xsl:text>.fform * { font-family: inherit; font-size: inherit; color: inherit; } </xsl:text>
					<xsl:text>.fform p { margin: 0 0 0.2em 0; } </xsl:text>
					<xsl:text>.fform p.title { text-align: center; font-size: 1.2em; font-weight: bold; margin-top: 1em; margin-bottom: 1em; } </xsl:text>
					<xsl:text>.fform p.title .symbol { color: Gray; } </xsl:text>
					<xsl:text>.fform div.trescDok { margin-top: 1em; margin-bottom: 1em; border: solid 1px Gray; background-color: WhiteSmoke; } </xsl:text>
					<xsl:text>.fform div.trescDok table td { padding: 3px 0px 4px 15px; } </xsl:text>
					<xsl:text>.fform div.trescDok table table td.sublevel, .fform div.trescDok table table table { background-color: WhiteSmoke; } </xsl:text>
					<xsl:text>.fform div.daneDok { margin-top: 1em; margin-bottom: 1em; border: solid 1px #7099c5; background-color: #f0f0ff; } </xsl:text>
					<xsl:text>.fform div.daneDok table td { padding: 3px 0px 4px 15px; } </xsl:text>
					<xsl:text>.fform div.daneDok table table td.sublevel, .fform div.daneDok table table table { background-color: #f0f0ff; } </xsl:text>
					<xsl:text>.fform div.sigInfo { margin-top: 1em; margin-bottom: 1em; border: solid 1px #7099c5; background-color: #f0f0ff; } </xsl:text>
					<xsl:text>.fform div.sigInfo table td { padding: 3px 0px 4px 15px; } </xsl:text>
					<xsl:text>.fform td.label { width: 20%; color: Gray; } </xsl:text>
					<xsl:text>.fform td.value { font-weight: bold; width: 80%; } </xsl:text>
					<xsl:text>.fform td.value2 { width: 80%; } </xsl:text>
					<xsl:text>.fform table { width: 100%; } </xsl:text>
					<xsl:text>.fform table td.sublevel, .fform table table { background-color: White; } </xsl:text>
					<xsl:text>.fform table table table td.sublevel, .fform table table table table { background-color: White; } </xsl:text>
				</style>
			</head>
			<body class="fform">
				<div class="trescDok">
					<p class="title">
						Deklaracja o wysokości opłaty za gospodarowanie odpadami komunalnymi składana przez właścicieli nieruchomości, na których znajdują się domki letniskowe lub innych nieruchomości wykorzystywanych na cele rekreacyjno-wypoczynkowe, wykorzystywanych jedynie przez część roku
					</p>
					<table>
						<xsl:apply-templates select="dok:TrescDokumentu/*"/>
					</table>
				</div>
				<div class="daneDok">
					<p class="title">Metryka dokumentu</p>
					<table>
						<xsl:apply-templates select="dok:DaneDokumentu"/>
					</table>
				</div>
				<div class="sigInfo">
					<p class="title">Podpisy elektroniczne</p>
					<xsl:choose>
						<xsl:when test="ds:Signature">
							<p>
								<xsl:text>Dokument został podpisany</xsl:text>
								<xsl:text> - aby go zweryfikować należy użyć oprogramowania do weryfikacji podpisu.</xsl:text>
							</p>
							<xsl:choose>
								<xsl:when test="count(//dok:Dokument/ds:Signature/ds:Object/descendant::*[local-name() = 'SigningTime']) &gt; 1">
									<p>Daty złożenia podpisu:</p>
								</xsl:when>
								<xsl:when test="count(//dok:Dokument/ds:Signature/ds:Object/descendant::*[local-name() = 'SigningTime']) = 1">
									<p>Data złożenia podpisu:</p>
								</xsl:when>
								<xsl:when test="0 &gt;= count(//dok:Dokument/ds:Signature/ds:Object/descendant::*[local-name() = 'SigningTime'])">
								</xsl:when>
							</xsl:choose>
							<table>
								<xsl:for-each select="ds:Signature/ds:Object/descendant::*[local-name() = 'SigningTime']">
									<tr>
										<td>Data złożenia podpisu:</td>
										<td>
											<xsl:value-of select="."/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:when>
						<xsl:otherwise>
							<p style="padding: 5px;">Dokument nie zawiera podpisu elektronicznego.</p>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="dok:DaneDokumentu">
		<xsl:if test="str:Naglowek/str:NazwaDokumentu">
			<tr>
				<td class="label">Nazwa dokumentu</td>
				<td class="value">
					<xsl:value-of select="str:Naglowek/str:NazwaDokumentu"/>
				</td>
			</tr>
		</xsl:if>
		<xsl:apply-templates select="meta:Identyfikator"/>
		<xsl:for-each select="str:Adresaci">
			<tr>
				<td class="sublevel" colspan="2">
					Adresat
					<br/>
					<table class="level2">
						<xsl:apply-templates select="meta:Podmiot"/>
					</table>
				</td>
			</tr>
		</xsl:for-each>
		<xsl:for-each select="str:Nadawcy">
			<tr>
				<td class="sublevel" colspan="2">
					Nadawca
					<br/>
					<table>
						<xsl:apply-templates select="meta:Podmiot"/>
					</table>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	
	<xsl:template match="adr:Adres">
		<xsl:apply-templates select="adr:KodPocztowy"/>
		<xsl:apply-templates select="adr:Poczta"/>
		<xsl:apply-templates select="adr:Miejscowosc"/>
		<xsl:apply-templates select="adr:Ulica"/>
		<xsl:apply-templates select="adr:Budynek"/>
		<xsl:apply-templates select="adr:Lokal"/>
		<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
		<xsl:apply-templates select="adr:Kraj"/>
		<xsl:apply-templates select="adr:TERC"/>
		<xsl:apply-templates select="adr:SIMC"/>
		<xsl:apply-templates select="adr:ULIC"/>
		<xsl:apply-templates select="adr:Wojewodztwo"/>
		<xsl:apply-templates select="adr:Powiat"/>
		<xsl:apply-templates select="adr:Gmina"/>
		<xsl:apply-templates select="adr:Uwagi"/>
	</xsl:template>
	<xsl:template match="adr:KodPocztowy">
		<tr>
			<td class="label">Kod pocztowy</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Poczta">
		<tr>
			<td class="label">Poczta</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Miejscowosc">
		<tr>
			<td class="label">Miejscowość</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Ulica">
		<tr>
			<td class="label">Ulica</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Budynek">
		<tr>
			<td class="label">Nr budynku</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Lokal">
		<tr>
			<td class="label">Nr lokalu</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:SkrytkaPocztowa">
		<tr>
			<td class="label">Nr skrytki pocztowej</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Kraj">
		<tr>
			<td class="label">Kod kraju</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:TERC">
		<tr>
			<td class="label">Kod TERC</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:SIMC">
		<tr>
			<td class="label">Kod SIMC</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:ULIC">
		<tr>
			<td class="label">Kod ULIC</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Wojewodztwo">
		<tr>
			<td class="label">Województwo</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Powiat">
		<tr>
			<td class="label">Powiat</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Gmina">
		<tr>
			<td class="label">Gmina</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Uwagi">
		<tr>
			<td class="label">Uwagi dotyczące adresu</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Kontakt">
		<xsl:apply-templates select="adr:Telefon|adr:Faks|adr:Email|adr:URIKontakt|adr:InnyKontakt"/>
	</xsl:template>
	<xsl:template match="adr:Telefon">
		<tr>
			<td class="label">Telefon</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Faks">
		<tr>
			<td class="label">Faks</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:Email">
		<tr>
			<td class="label">E-mail</td>
			<td class="value">
				<a href="mailto:{text()}">
					<xsl:value-of select="text()"/>
				</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:URIKontakt">
		<tr>
			<td class="label">Kontakt URI</td>
			<td class="value">
				<a href="{text()}">
					<xsl:value-of select="text()"/>
				</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="adr:InnyKontakt">
		<tr>
			<td class="label">Inny kontakt</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>

	
	<xsl:template match="oso:Osoba">
		<xsl:apply-templates select="oso:IdOsoby"/>
		<xsl:apply-templates select="oso:Imie"/>
		<xsl:apply-templates select="oso:ImieDrugie"/>
		<xsl:if test="oso:Nazwisko">
			<tr>
				<td class="label">Nazwisko</td>
				<td class="value">
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='pierwszy']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='drugi']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='trzeci']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[not(@rodzajCzlonu)]">
						<xsl:value-of select="oso:Nazwisko[not(@rodzajCzlonu)]"/>
						<xsl:text> </xsl:text>
					</xsl:if>
				</td>
			</tr>
		</xsl:if>
		<xsl:apply-templates select="adr:Adres"/>
		<xsl:apply-templates select="adr:Kontakt"/>
	</xsl:template>
	<xsl:template match="oso:IdOsoby">
		<xsl:apply-templates select="oso:PESEL"/>
		<xsl:apply-templates select="oso:NIP"/>
		<xsl:apply-templates select="oso:InnyIdentyfikator"/>
	</xsl:template>
	<xsl:template match="oso:PESEL">
		<tr>
			<td class="label">Numer PESEL</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NIP">
		<tr>
			<td class="label">Numer NIP</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:InnyIdentyfikator">
		<tr>
			<td class="label">
				Identyfikator
				<xsl:value-of select="oso:TypIdentyfikatora"/>
			</td>
			<td class="value">
				<xsl:value-of select="oso:WartoscIdentyfikatora"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Imie">
		<tr>
			<td class="label">Imię</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:ImieDrugie">
		<tr>
			<td class="label">Imię drugie</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:ImieOjca">
		<tr>
			<td class="label">Imię ojca</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:ImieMatki">
		<tr>
			<td class="label">Imię matki</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Nazwisko[not(@rodzajCzlonu)]">
		<tr>
			<td class="label">Nazwisko</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Nazwisko[@rodzajCzlonu='pierwszy']">
		<tr>
			<td class="label">Nazwisko - człon pierwszy</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Nazwisko[@rodzajCzlonu='drugi']">
		<tr>
			<td class="label">Nazwisko - człon drugi</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Nazwisko[@rodzajCzlonu='trzeci']">
		<tr>
			<td class="label">Nazwisko - człon trzeci</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NazwiskoRodowe">
		<tr>
			<td class="label">Nazwisko rodowe</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NazwiskoRodoweOjca">
		<tr>
			<td class="label">Nazwisko rodowe ojca</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NazwiskoRodoweMatki">
		<tr>
			<td class="label">Nazwisko rodowe matki</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NazwiskoPoprzednie">
		<tr>
			<td class="label">Nazwisko poprzednie</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:MiejsceUrodzenia">
		<tr>
			<td class="label">Miejsce urodzenia</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:DataUrodzenia">
		<tr>
			<td class="label">Data urodzenia</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Plec">
		<tr>
			<td class="label">Płeć</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:RodzajDowoduTozsamosci">
		<tr>
			<td class="label">Rodzaj dowodu tożsamości</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:NrDowoduTozsamosci">
		<tr>
			<td class="label">Nr dowodu tożsamości</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:DataWydaniaDowoduTozsamosci">
		<tr>
			<td class="label">Data wydania dowodu tożsamości</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Obywatelstwo">
		<tr>
			<td class="label">Obywatelstwo</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Narodowosc">
		<tr>
			<td class="label">Narodowość</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:StopienPokrewienstwa">
		<tr>
			<td class="label">Stopień pokrewieństwa</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:StanCywilny">
		<tr>
			<td class="label">Stan cywilny</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:WyksztalceniePoziom">
		<tr>
			<td class="label">Poziom wykształcenia</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:WyksztalcenieOpis">
		<tr>
			<td class="label">Opis wykształcenia</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="oso:Zawod">
		<tr>
			<td class="label">Zawód</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>

	
	<xsl:template match="inst:Instytucja">
		<xsl:apply-templates select="inst:IdInstytucji/inst:KRS"/>
		<xsl:apply-templates select="inst:IdInstytucji/inst:NIP"/>
		<xsl:apply-templates select="inst:IdInstytucji/inst:REGON"/>
		<xsl:apply-templates select="inst:IdInstytucji/inst:InnyIdentyfikator"/>
		<xsl:apply-templates select="inst:NazwaInstytucji"/>
		<xsl:if test="adr:Adres">
			<tr>
				<td class="sublevel" colspan="2">
					Adres
					<br/>
					<table>
						<xsl:apply-templates select="adr:Adres"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="adr:Kontakt">
			<tr>
				<td class="sublevel" colspan="2">
					Kontakt
					<br/>
					<table>
						<xsl:apply-templates select="adr:Kontakt"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="inst:Jednostka">
			<tr>
				<td class="sublevel" colspan="2">
					Jednostka organizacyjna
					<br/>
					<table>
						<xsl:apply-templates select="inst:Jednostka"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="inst:Pracownik">
			<tr>
				<td class="sublevel" colspan="2">
					Pracownik
					<br/>
					<table>
						<xsl:apply-templates select="inst:Pracownik"/>
					</table>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="inst:Jednostka">
		<xsl:apply-templates select="inst:NazwaInstytucji"/>
		<xsl:if test="adr:Adres">
			<tr>
				<td class="sublevel" colspan="2">
					Adres
					<br/>
					<table>
						<xsl:apply-templates select="adr:Adres"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="adr:Kontakt">
			<tr>
				<td class="sublevel" colspan="2">
					Kontakt
					<br/>
					<table>
						<xsl:apply-templates select="adr:Kontakt"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="inst:Jednostka">
			<tr>
				<td class="sublevel" colspan="2">
					Jednostka organizacyjna
					<br/>
					<table>
						<xsl:apply-templates select="inst:Jednostka"/>
					</table>
				</td>
			</tr>
		</xsl:if>
		<xsl:apply-templates select="inst:Poziom"/>
		<xsl:if test="inst:Pracownik">
			<tr>
				<td class="sublevel" colspan="2">
					Pracownik
					<br/>
					<table>
						<xsl:apply-templates select="inst:Pracownik"/>
					</table>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="inst:KRS">
		<tr>
			<td class="label">Numer KRS</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:NIP">
		<tr>
			<td class="label">Numer NIP</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:REGON">
		<tr>
			<td class="label">Numer REGON</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:InnyIdentyfikator">
		<tr>
			<td class="label">
				Identyfikator
				<xsl:value-of select="inst:TypIdentyfikatora"/>
			</td>
			<td class="value">
				<xsl:value-of select="inst:WartoscIdentyfikatora"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:NazwaInstytucji">
		<tr>
			<td class="label">Nazwa</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:Poziom">
		<tr>
			<td class="label">Poziom w strukturze organizacyjnej</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="inst:Pracownik">
		<xsl:apply-templates select="oso:IdOsoby"/>
		<xsl:apply-templates select="oso:Imie"/>
		<xsl:apply-templates select="oso:ImieDrugie"/>
		<xsl:if test="oso:Nazwisko">
			<tr>
				<td class="label">Nazwisko</td>
				<td class="value">
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='pierwszy']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='drugi']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[@rodzajCzlonu='trzeci']">
						<xsl:value-of select="oso:Nazwisko[@rodzajCzlonu='pierwszy']"/>
						<xsl:text> </xsl:text>
					</xsl:if>
					<xsl:if test="oso:Nazwisko[not(@rodzajCzlonu)]">
						<xsl:value-of select="oso:Nazwisko[not(@rodzajCzlonu)]"/>
						<xsl:text> </xsl:text>
					</xsl:if>
				</td>
			</tr>
		</xsl:if>
		<xsl:apply-templates select="adr:Kontakt"/>
		<xsl:apply-templates select="inst:Funkcja"/>
	</xsl:template>
	<xsl:template match="inst:Funkcja">
		<tr>
			<td class="label">Funkcja</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>

	
	<xsl:template match="meta:Data">
		<tr>
			<td class="label">
				<xsl:choose>
					<xsl:when test="@typDaty='dostepnyPo'">
						Data udostępnienia
					</xsl:when>
					<xsl:when test="@typDaty='opublikowany'">
						Data opublikowania
					</xsl:when>
					<xsl:when test="@typDaty='stworzony'">
						Data stworzenia
					</xsl:when>
					<xsl:when test="@typDaty='uzyskany'">
						Data uzyskania
					</xsl:when>
					<xsl:when test="@typDaty='otrzymany'">
						Data otrzymania
					</xsl:when>
					<xsl:when test="@typDaty='wyslany'">
						Data wysłania
					</xsl:when>
					<xsl:when test="@typDaty='zaakceptowany'">
						Data zaakceptowania
					</xsl:when>
					<xsl:when test="@typDaty='zatwierdzony'">
						Data zatwierdzenia
					</xsl:when>
					<xsl:when test="@typDaty='zmodyfikowany'">
						Data zmodyfikowania
					</xsl:when>
					<xsl:when test="@typDaty='datySkrajne'">
						Daty skrajne
					</xsl:when>
					<xsl:when test="@typDaty='zdarzenia'">
						Data zdarzenie
					</xsl:when>
					<xsl:when test="@typDaty='waznosci'">
						Data ważności
					</xsl:when>
					<xsl:when test="@typDaty='odrzucony'">
						Data odrzucenia
					</xsl:when>
					<xsl:when test="@typDaty='inna'">
						Inna data
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="value">
				<xsl:if test="meta:Czas">
					<xsl:value-of select="meta:Czas"/>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="meta:Od">
					<xsl:text>od </xsl:text>
					<xsl:value-of select="meta:Od"/>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="meta:Do">
					<xsl:text>do </xsl:text>
					<xsl:value-of select="meta:Do"/>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="@typDatyUzupelnienie">
					<br/>
					<xsl:value-of select="@typDatyUzupelnienie"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="meta:Od">
		<tr>
			<td class="label">Od</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="meta:Do">
		<tr>
			<td class="label">Do</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="meta:Opis">
		<tr>
			<td class="label">Opis</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="meta:Identyfikator">
		<tr>
			<td class="label">
				Identyfikator
				<xsl:value-of select="@typIdentyfikatora"/>
			</td>
			<td class="value">
				<xsl:value-of select="meta:Wartosc"/>
				<xsl:if test="meta:Podmiot/inst:Instytucja/inst:NazwaInstytucji">
					<br/>
					Rejestr prowadzony przez
					<xsl:value-of select="meta:Podmiot/inst:Instytucja/inst:NazwaInstytucji"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="meta:Podmiot">
		<xsl:apply-templates select="inst:Instytucja"/>
		<xsl:apply-templates select="oso:Osoba"/>
	</xsl:template>
	<xsl:template match="meta:ZnakSprawy">
		<tr>
			<td class="label">Znak sprawy</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>

	
	<xsl:template match="str:Zalaczniki">
		<xsl:apply-templates select="str:Zalacznik"/>
	</xsl:template>
	<xsl:template match="str:Zalacznik">
		<tr>
			<td class="label">Załącznik</td>
			<td class="value2">
				<xsl:call-template name="str_ZalacznikTypValue"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="str_ZalacznikTypValue">
		<xsl:choose>
			<xsl:when test="@kodowanie='URI'">
				<xsl:text>Załącznik zewnętrzny w formacie </xsl:text>
				<b>
					<xsl:value-of select="@format"/>
				</b>
				<xsl:text> dostępny pod adresem URI: </xsl:text>
				<b>
					<xsl:value-of select="str:DaneZalacznika"/>
				</b>
			</xsl:when>
			<xsl:when test="@kodowanie='base64'">
				<xsl:text>Załącznik w formacie </xsl:text>
				<b>
					<xsl:value-of select="@format"/>
				</b>
				<xsl:text> zapisany wewnątrz treści dokumentu.</xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="@nazwaPliku">
			<br/>
			Nazwa pliku:
			<b>
				<xsl:value-of select="@nazwaPliku"/>
			</b>
		</xsl:if>
		<xsl:if test="str:OpisZalacznika">
			<br/>
			Opis załącznika:
			<br/>
			<xsl:value-of select="str:OpisZalacznika"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="str:OpisZalacznika">
		<tr>
			<td class="label">Opis załącznika</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="str:NumerDokumentu">
		<tr>
			<td class="label">Numer dokumentu</td>
			<td class="value">
				<xsl:value-of select="text()"/>
			</td>
		</tr>
	</xsl:template>

	
	<xsl:template name="xsd_boolean">
		<xsl:choose>
			<xsl:when test="text()='true'">
				<xsl:text>TAK</xsl:text>
			</xsl:when>
			<xsl:when test="text()='1'">
				<xsl:text>TAK</xsl:text>
			</xsl:when>
			<xsl:when test="text()='false'">
				<xsl:text>NIE</xsl:text>
			</xsl:when>
			<xsl:when test="text()='0'">
				<xsl:text>NIE</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Zrodlo">
<tr>
            <td class="label">ŹRÓDŁO</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:PodstawaPrawna">
<tr>
            <td class="label">PODSTAWA PRAWNA</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Skladajacy">
<tr>
            <td class="label">SKŁADAJĄCY</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:TerminSkladania">
<tr>
            <td class="label">TERMIN SKŁADANIA</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:MiejsceSkladaniaDeklaracji">
<tr>
            <td class="label">MIEJSCE SKŁADANIA DEKLARACJI</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia">
<tr>
            <td class="sublevel" colspan="2">A. OBOWIĄZEK ZŁOŻENIA DEKLARACJI<br/>
<table>
<xsl:apply-templates select="dok:OkolicznosciPowodujaceZlozenieDeklaracji"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji">
<tr>
            <td class="sublevel" colspan="2">Okoliczności powodujące
											obowiązek złożenia
											deklaracji<br/>
<table>
<xsl:apply-templates select="dok:Pierwsza"/>
<xsl:apply-templates select="dok:Zmiana"/>
<xsl:apply-templates select="dok:Korekta"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Pierwsza">
<tr>
            <td class="sublevel" colspan="2">pierwsza
															deklaracja<br/>
<table>
<xsl:apply-templates select="dok:Data"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Pierwsza/dok:Data">
<tr>
            <td class="label">Data
																		(rok-miesiąc-dzień)</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Zmiana">
<tr>
            <td class="sublevel" colspan="2">zmiana
															danych
															deklaracj<br/>
<table>
<xsl:apply-templates select="dok:Data"/>
<xsl:apply-templates select="dok:Przyczyna"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Zmiana/dok:Data">
<tr>
            <td class="label">Data
																		(rok-miesiąc-dzień)</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Zmiana/dok:Przyczyna">
<tr>
            <td class="label">Przyczyna
																		zmiany</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Korekta">
<tr>
            <td class="sublevel" colspan="2">korekta
															deklaracji<br/>
<table>
<xsl:apply-templates select="dok:Data"/>
<xsl:apply-templates select="dok:Przyczyna"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Korekta/dok:Data">
<tr>
            <td class="label">Data
																		(rok-miesiąc-dzień)</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:ObowiazekZlozenia/dok:OkolicznosciPowodujaceZlozenieDeklaracji/dok:Korekta/dok:Przyczyna">
<tr>
            <td class="label">Przyczyna
																		korekty</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego">
<tr>
            <td class="sublevel" colspan="2">B. DANE SKŁADAJĄCEGO DEKLARACJĘ<br/>
<table>
<xsl:apply-templates select="dok:SkladajacyDeklaracje"/>
<xsl:apply-templates select="dok:RodzajSkladajacego"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje">
<tr>
            <td class="sublevel" colspan="2">Składający deklarację<br/>
<table>
<xsl:apply-templates select="dok:Wlasciciel"/>
<xsl:apply-templates select="dok:Wspolwlasciciel"/>
<xsl:apply-templates select="dok:Inny"/>
<xsl:apply-templates select="dok:Jednostka"/>
<xsl:apply-templates select="dok:Uzytkownik"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje/dok:Wlasciciel">
<tr>
            <td class="label">Właściciel</td>
            <td class="value">
                <xsl:call-template name="xsd_boolean"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje/dok:Wspolwlasciciel">
<tr>
            <td class="label">Współwłaściciel</td>
            <td class="value">
                <xsl:call-template name="xsd_boolean"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje/dok:Inny">
<tr>
            <td class="label">Inny podmiot
															władający
															nieruchomością</td>
            <td class="value">
                <xsl:call-template name="xsd_boolean"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje/dok:Jednostka">
<tr>
            <td class="label">Jednostka
															organizacyjna
															i osoba
															posiadająca
															nieruchomość
															w zarządzie
															lub
															użytkowaniu</td>
            <td class="value">
                <xsl:call-template name="xsd_boolean"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:SkladajacyDeklaracje/dok:Uzytkownik">
<tr>
            <td class="label">Uzytkownik
															wieczysty</td>
            <td class="value">
                <xsl:call-template name="xsd_boolean"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego">
<tr>
            <td class="sublevel" colspan="2">Rodzaj składającego
											deklarację<br/>
<table>
<xsl:apply-templates select="dok:OsobaFizyczna"/>
<xsl:apply-templates select="dok:OsobaPrawna"/>
<xsl:apply-templates select="dok:JednostkaOrganizacyjna"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna">
<tr>
            <td class="sublevel" colspan="2">Osoba
															fizyczna<br/>
<table>
<xsl:apply-templates select="dok:OsobaFizycznaDane"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna/dok:OsobaFizycznaDane">
<tr>
            <td class="sublevel" colspan="2"> <br/>
<table>
<xsl:apply-templates select="oso:Imie"/>
<xsl:apply-templates select="oso:Nazwisko"/>
<xsl:apply-templates select="dok:Pesel"/>
<xsl:apply-templates select="dok:AdresNieruchomosci"/>
<xsl:apply-templates select="dok:AdresZamieszkania"/>
<xsl:apply-templates select="dok:TelefonEmail"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna/dok:OsobaFizycznaDane/dok:Pesel">
<tr>
            <td class="label">PESEL</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna/dok:OsobaFizycznaDane/dok:AdresNieruchomosci">
<tr>
            <td class="sublevel" colspan="2">C.
																					ADRES
																					NIERUCHOMOŚCI,
																					NA
																					KTÓREJ
																					ZNAJDUJĄ
																					SIĘ
																					DOMKI
																					LETNISKOWE
																					LUB
																					WYKORZYSTYWANEJ
																					NA
																					CELE
																					REKREACYJNO-WYPOCZYNKOWE,
																					WYKORZYSTYWANEJ
																					JEDYNIE
																					PRZEZ
																					CZĘŚĆ
																					ROKU<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna/dok:OsobaFizycznaDane/dok:AdresZamieszkania">
<tr>
            <td class="sublevel" colspan="2">D.
																					ADRES
																					ZAMIESZKANIA<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaFizyczna/dok:OsobaFizycznaDane/dok:TelefonEmail">
<tr>
            <td class="sublevel" colspan="2">E.
																					NUMER
																					TELEFONU
																					/
																					ADRES
																					POCZTY
																					ELEKTRONICZNE]
																					WŁAŚCICIELA
																					NIERUCHOMOŚCI<br/>
<table>
<xsl:apply-templates select="adr:Telefon"/>
<xsl:apply-templates select="adr:Email"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna">
<tr>
            <td class="sublevel" colspan="2">Osoba prawna<br/>
<table>
<xsl:apply-templates select="dok:OsobaPrawnaDane"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna/dok:OsobaPrawnaDane">
<tr>
            <td class="sublevel" colspan="2"> <br/>
<table>
<xsl:apply-templates select="dok:NazwaPelna"/>
<xsl:apply-templates select="inst:REGON"/>
<xsl:apply-templates select="dok:AdresNieruchomosci"/>
<xsl:apply-templates select="dok:AdresSiedziby"/>
<xsl:apply-templates select="dok:TelefonEmail"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna/dok:OsobaPrawnaDane/dok:NazwaPelna">
<tr>
            <td class="label">Nazwa pełna</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna/dok:OsobaPrawnaDane/dok:AdresNieruchomosci">
<tr>
            <td class="sublevel" colspan="2">C. ADRES NIERUCHOMOŚCI, NA KTÓREJ ZNAJDUJĄ SIĘ DOMKI LETNISKOWE LUB
WYKORZYSTYWANEJ NA CELE REKREACYJNO-WYPOCZYNKOWE, WYKORZYSTYWANEJ
JEDYNIE PRZEZ CZĘŚĆ ROKU<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna/dok:OsobaPrawnaDane/dok:AdresSiedziby">
<tr>
            <td class="sublevel" colspan="2">D. SIEDZIBA SKŁADAJĄCEGO DEKLARACJĘ<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:OsobaPrawna/dok:OsobaPrawnaDane/dok:TelefonEmail">
<tr>
            <td class="sublevel" colspan="2">E. NUMER TELEFONU / ADRES POCZTY ELEKTRONICZNE] WŁAŚCICIELA NIERUCHOMOŚCI<br/>
<table>
<xsl:apply-templates select="adr:Telefon"/>
<xsl:apply-templates select="adr:Email"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna">
<tr>
            <td class="sublevel" colspan="2">Jednostka
															organizacyjna
															nie
															posiadająca
															osobowości
															prawnej<br/>
<table>
<xsl:apply-templates select="dok:OsobaPrawnaDane"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna/dok:OsobaPrawnaDane">
<tr>
            <td class="sublevel" colspan="2"> <br/>
<table>
<xsl:apply-templates select="dok:NazwaPelna"/>
<xsl:apply-templates select="inst:REGON"/>
<xsl:apply-templates select="dok:AdresNieruchomosci"/>
<xsl:apply-templates select="dok:AdresSiedziby"/>
<xsl:apply-templates select="dok:TelefonEmail"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna/dok:OsobaPrawnaDane/dok:NazwaPelna">
<tr>
            <td class="label">Nazwa pełna</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna/dok:OsobaPrawnaDane/dok:AdresNieruchomosci">
<tr>
            <td class="sublevel" colspan="2">C. ADRES NIERUCHOMOŚCI, NA KTÓREJ ZNAJDUJĄ SIĘ DOMKI LETNISKOWE LUB
WYKORZYSTYWANEJ NA CELE REKREACYJNO-WYPOCZYNKOWE, WYKORZYSTYWANEJ
JEDYNIE PRZEZ CZĘŚĆ ROKU<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna/dok:OsobaPrawnaDane/dok:AdresSiedziby">
<tr>
            <td class="sublevel" colspan="2">D. SIEDZIBA SKŁADAJĄCEGO DEKLARACJĘ<br/>
<table>
<xsl:apply-templates select="adr:KodPocztowy"/>
<xsl:apply-templates select="adr:Poczta"/>
<xsl:apply-templates select="adr:Miejscowosc"/>
<xsl:apply-templates select="adr:Ulica"/>
<xsl:apply-templates select="adr:Budynek"/>
<xsl:apply-templates select="adr:Lokal"/>
<xsl:apply-templates select="adr:SkrytkaPocztowa"/>
<xsl:apply-templates select="adr:Kraj"/>
<xsl:apply-templates select="adr:TERC"/>
<xsl:apply-templates select="adr:SIMC"/>
<xsl:apply-templates select="adr:ULIC"/>
<xsl:apply-templates select="adr:Wojewodztwo"/>
<xsl:apply-templates select="adr:Powiat"/>
<xsl:apply-templates select="adr:Gmina"/>
<xsl:apply-templates select="adr:Uwagi"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:DaneSkladajacego/dok:RodzajSkladajacego/dok:JednostkaOrganizacyjna/dok:OsobaPrawnaDane/dok:TelefonEmail">
<tr>
            <td class="sublevel" colspan="2">E. NUMER TELEFONU / ADRES POCZTY ELEKTRONICZNE] WŁAŚCICIELA NIERUCHOMOŚCI<br/>
<table>
<xsl:apply-templates select="adr:Telefon"/>
<xsl:apply-templates select="adr:Email"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:WysokoscRocznejOplaty">
<tr>
            <td class="sublevel" colspan="2">F. WYSOKOŚĆ ROCZNEJ OPŁATY ZA GOSPODAROWANIE ODPADAMI KOMUNALNYMI<br/>
<table>
<xsl:apply-templates select="dok:RyczaltowaStawka1domek"/>
<xsl:apply-templates select="dok:IloscDomkow"/>
<xsl:apply-templates select="dok:RyczaltowaStawkaZaRok"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:WysokoscRocznejOplaty/dok:RyczaltowaStawka1domek">
<tr>
            <td class="label">Ryczałtowa roczna stawka opłaty od jednego domku letniskowego lub innej
nieruchomości wykorzystywanej na cele rekreacyjno-wypoczynkowe,
wykorzystywanej jedynie przez część roku [zł]</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:WysokoscRocznejOplaty/dok:IloscDomkow">
<tr>
            <td class="label">Ilość domków letniskowych znajdujących się na terenie nieruchomości</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:WysokoscRocznejOplaty/dok:RyczaltowaStawkaZaRok">
<tr>
            <td class="label">Ryczałtowa stawka za gospodarowanie odpadami komunalnymi za rok
w przypadku, gdy na nieruchomości znajduje się więcej niż jeden domek
letniskowy [zł]</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Oswiadczenie2">
<tr>
            <td class="sublevel" colspan="2">G. OŚWIADCZENIE SKŁADAJĄCEGO / OSOBY
								REPREZENTUJĄCEJ SKŁADAJĄCEGO<br/>
<table>
<xsl:apply-templates select="dok:Oswiadczam"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Oswiadczenie2/dok:Oswiadczam">
<tr>
            <td class="sublevel" colspan="2">Oświadczam, że podane przeze
											mnie dane są zgodne ze
											stanem faktycznym.<br/>
<table>
<xsl:apply-templates select="oso:Imie"/>
<xsl:apply-templates select="oso:Nazwisko"/>
<xsl:apply-templates select="dok:Data"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Oswiadczenie2/dok:Oswiadczam/dok:Data">
<tr>
            <td class="label">Data</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Adnotacje">
<tr>
            <td class="sublevel" colspan="2">H. ADNOTACJE ORGANU<br/>
<table>
<xsl:apply-templates select="dok:DataPrzyjecia"/>
<xsl:apply-templates select="dok:PodpisPrzyjmujacego"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Adnotacje/dok:DataPrzyjecia">
<tr>
            <td class="label">Data przyjęcia</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Adnotacje/dok:PodpisPrzyjmujacego">
<tr>
            <td class="label">Dane
											przyjmującego</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="dok:Dokument/dok:TrescDokumentu/dok:Pouczenie">
<tr>
            <td class="label">Pouczenie</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:DataWszczeciaEgzekucji">
<tr>
            <td class="label">Data wszczęcia egzekucji</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:Rok">
<tr>
            <td class="label">Rok</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:NumerSystemowyOsoby">
<tr>
            <td class="label">Numer systemowy osoby</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:RodzajDecyzji">
<tr>
            <td class="label">Rodzaj decyzji</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:NumerDecyzji">
<tr>
            <td class="label">Numer decyzji</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OznaczenieWaluty">
<tr>
            <td class="label">Waluta</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:NumerSystemowyWniosku">
<tr>
            <td class="label">Numer systemowy wniosku</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OdbiorDecyzji">
<tr>
            <td class="sublevel" colspan="2">Osoba odbierająca decyzję<br/>
<table>
<xsl:apply-templates select="typy:Data"/>
<xsl:apply-templates select="typy:Potwierdzajacy"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OdbiorDecyzji/typy:Data">
<tr>
            <td class="label">Data</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OdbiorDecyzji/typy:Potwierdzajacy">
<tr>
            <td class="sublevel" colspan="2">Podpisujący<br/>
<table>
<xsl:apply-templates select="oso:IdOsoby"/>
<xsl:apply-templates select="oso:Imie"/>
<xsl:apply-templates select="oso:Nazwisko"/>
<xsl:apply-templates select="adr:Kontakt"/>
<xsl:apply-templates select="inst:Funkcja"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OkresZlozenia">
<tr>
            <td class="label">Okres złożenia</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:DataWniosku">
<tr>
            <td class="label">Data</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:Decyzja">
<tr>
            <td class="sublevel" colspan="2">Decyzja<br/>
<table>
<xsl:apply-templates select="typy:RodzajDecyzji"/>
<xsl:apply-templates select="typy:DataWydaniaDecyzji"/>
<xsl:apply-templates select="typy:NumerDecyzji"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:NumerTytuluWykonawczego">
<tr>
            <td class="label">Numer tytułu wykonawczego</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:SeriaNumerDokumentu">
<tr>
            <td class="label">Seria i numer dokumentu</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:SygnaturaSprawy">
<tr>
            <td class="label">Sygnatura sprawy</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:OsobyObjeteDecyzjaLiczba">
<tr>
            <td class="label">Liczba osób objętych decyzją</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:DataWydaniaDecyzji">
<tr>
            <td class="label">Data wydania decyzji</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:PodpisWnioskodawcy">
<tr>
            <td class="sublevel" colspan="2">Podpis  wnioskodawcy<br/>
<table>
<xsl:apply-templates select="typy:Data"/>
<xsl:apply-templates select="typy:Potwierdzajacy"/>
</table>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:PodpisWnioskodawcy/typy:Data">
<tr>
            <td class="label">Data</td>
            <td class="value">
                <xsl:value-of select="text()"/>
            </td>
        </tr>
</xsl:template>
<xsl:template match="typy:PodpisWnioskodawcy/typy:Potwierdzajacy">
<tr>
            <td class="sublevel" colspan="2">Podpisujący<br/>
<table>
<xsl:apply-templates select="oso:IdOsoby"/>
<xsl:apply-templates select="oso:Imie"/>
<xsl:apply-templates select="oso:Nazwisko"/>
<xsl:apply-templates select="adr:Kontakt"/>
<xsl:apply-templates select="inst:Funkcja"/>
</table>
            </td>
        </tr>
</xsl:template>
</xsl:stylesheet>